# Copyright (C) 2021-2025, dilemma-vr.games
# Shared under MIT license

"""Entry point for the DilemmaWarden app"""

from PyQt5.QtWidgets import QApplication
from .model import Model, modes
from .controller import MainController
from .view import MainView
from .utils import get_drive_list

class App(QApplication):
    """DilemmaWarden GUI app, sets up model, view and controller"""

    def __init__(self, sys_argv):
        super(App, self).__init__(sys_argv)
        self.model = Model()
        self.main_controller = MainController(self.model)
        self.main_view = MainView(self.model, self.main_controller)

        self.model.mode = modes.remote
        self.model.drives = get_drive_list()
        self.model.selected_drive = 0
        self.model.tray_open = False
        self.main_view.show()
